/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.gantry;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11683;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GantryCarriageRenderer
extends KineticBlockEntityRenderer<GantryCarriageBlockEntity, GantryCarriageRenderState> {
    public GantryCarriageRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public GantryCarriageRenderState createRenderState() {
        return new GantryCarriageRenderState();
    }

    @Override
    public void extractRenderState(GantryCarriageBlockEntity be, GantryCarriageRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)GantryCarriageBlock.FACING);
        Boolean alongFirst = (Boolean)blockState.method_11654((class_2769)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        class_2350.class_2351 rotationAxis = state.axis;
        class_2338 visualPos = facing.method_10171() == class_2350.class_2352.field_11056 ? be.method_11016() : be.method_11016().method_10093(facing.method_10153());
        float angleForBE = GantryCarriageRenderer.getAngleForBE(be, visualPos, rotationAxis);
        class_2350.class_2351 gantryAxis = class_2350.class_2351.field_11048;
        for (class_2350.class_2351 axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facing.method_10166()) continue;
            gantryAxis = axis;
        }
        if (gantryAxis == class_2350.class_2351.field_11048 && facing == class_2350.field_11036) {
            angleForBE *= -1.0f;
        }
        if (gantryAxis == class_2350.class_2351.field_11052 && (facing == class_2350.field_11043 || facing == class_2350.field_11034)) {
            angleForBE *= -1.0f;
        }
        state.cogs = CachedBuffers.partial(AllPartialModels.GANTRY_COGS, blockState);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (float)(facing == class_2350.field_11036 ? 0 : (facing == class_2350.field_11033 ? 180 : 90));
        state.yRot2 = (float)Math.PI / 180 * (float)(alongFirst ^ facing.method_10166() == class_2350.class_2351.field_11048 ? 0 : 90);
        state.xRot2 = (float)Math.PI / 180 * -angleForBE;
    }

    @Override
    protected class_1921 getRenderType(GantryCarriageBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    public static float getAngleForBE(KineticBlockEntity be, class_2338 pos, class_2350.class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        float offset = GantryCarriageRenderer.getRotationOffsetForPosition(be, pos, axis);
        return (time * be.getSpeed() * 3.0f / 20.0f + offset) % 360.0f;
    }

    @Override
    protected class_2680 getRenderedBlockState(GantryCarriageBlockEntity be) {
        return GantryCarriageRenderer.shaft(GantryCarriageRenderer.getRotationAxisOf(be));
    }

    @Environment(value=EnvType.CLIENT)
    public static class GantryCarriageRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer cogs;
        public float yRot;
        public float xRot;
        public float yRot2;
        public float xRot2;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cogs.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateY(this.yRot2);
            if (this.xRot2 != 0.0f) {
                ((SuperByteBuffer)((SuperByteBuffer)this.cogs.translate(0.0f, -0.5625f, 0.0f)).rotateX(this.xRot2)).translate(0.0f, 0.5625f, 0.0f);
            }
            ((SuperByteBuffer)this.cogs.uncenter()).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

